% Заряд конденсатора C через сопротивление R от источника Uo
clear all
% Выполним решение дифференциального уравнения заряда
syms Uo Uc(t) R C
% Функция заряда конденсатора
Uc=dsolve(diff(Uc) == (Uo-Uc)/(R*C), Uc(0)==0) 
% Зададим параметры схемы
Uo=5;                  % Напряжение в вольтах на входе
C=910e-12;             % Емкость в фарадах
R=200;                 % Сопротивление в омах
t=[0:10e-9:1000e-9];   % Время в секундах
y=eval(Uc);            % Подготовить график
plot(t,y);             % Прорисовать график